/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.Effect;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.DispatchResult;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.effects.EffectTracker;
import com.cobblemon.mod.common.entity.pokemon.effects.TransformEffect;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/TransformInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "message", "<init>", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "getBattle", "()Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "expectedTarget", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "getExpectedTarget", "()Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "common"})
public final class TransformInstruction
implements InterpreterInstruction {
    @NotNull
    private final PokemonBattle battle;
    @NotNull
    private final BattleMessage message;
    @Nullable
    private final BattlePokemon expectedTarget;

    public TransformInstruction(@NotNull PokemonBattle battle, @NotNull BattleMessage message) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.battle = battle;
        this.message = message;
        this.expectedTarget = this.message.battlePokemon(0, this.battle);
    }

    @NotNull
    public final PokemonBattle getBattle() {
        return this.battle;
    }

    @NotNull
    public final BattleMessage getMessage() {
        return this.message;
    }

    @Nullable
    public final BattlePokemon getExpectedTarget() {
        return this.expectedTarget;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Pair<String, String> pair = this.message.pnxAndUuid(0);
        if (pair == null) {
            return;
        }
        String pnx = (String)pair.component1();
        BattleActor actor = (BattleActor)battle.getActorAndActiveSlotFromPNX(pnx).component1();
        BattlePokemon battlePokemon = this.message.battlePokemon(0, battle);
        if (battlePokemon == null) {
            return;
        }
        BattlePokemon pokemon = battlePokemon;
        BattlePokemon battlePokemon2 = this.message.battlePokemon(1, battle);
        if (battlePokemon2 == null) {
            return;
        }
        BattlePokemon targetPokemon = battlePokemon2;
        Effect effect = BattleMessage.effect$default(this.message, null, 1, null);
        ShowdownInterpreter.INSTANCE.broadcastOptionalAbility(battle, effect, pokemon);
        battle.dispatch((Function0<? extends DispatchResult>)((Function0)() -> TransformInstruction.invoke$lambda$0(pokemon, targetPokemon, battle)));
        PokemonBattle.dispatchWaiting$default(battle, 0.0f, () -> TransformInstruction.invoke$lambda$1(pokemon, targetPokemon, battle, this, actor, pnx), 1, null);
    }

    private static final DispatchResult invoke$lambda$0(BattlePokemon $pokemon, BattlePokemon $targetPokemon, PokemonBattle $battle) {
        PokemonEntity pokemonEntity = $pokemon.getEntity();
        if (pokemonEntity == null) {
            return DispatchResultKt.getGO();
        }
        PokemonEntity entity = pokemonEntity;
        CompletableFuture<PokemonEntity> future = new TransformEffect($targetPokemon.getEffectedPokemon(), $battle.getStarted()).start(entity);
        return new UntilDispatch((Function0<Boolean>)((Function0)() -> TransformInstruction.invoke$lambda$0$0(future)));
    }

    private static final boolean invoke$lambda$0$0(CompletableFuture $future) {
        CompletableFuture completableFuture = $future;
        return !(completableFuture != null ? !completableFuture.isDone() : false);
    }

    private static final Unit invoke$lambda$1(BattlePokemon $pokemon, BattlePokemon $targetPokemon, PokemonBattle $battle, TransformInstruction this$0, BattleActor $actor, String $pnx) {
        Object object = $pokemon.getEntity();
        PokemonProperties mock = object != null && (object = ((PokemonEntity)object).getEffects()) != null && (object = ((EffectTracker)object).getMockEffect()) != null ? object.getMock() : null;
        class_5250 pokemonName = $pokemon.getName();
        class_5250 targetPokemonName = $targetPokemon.getName();
        PokemonProperties pokemonProperties = mock;
        if (pokemonProperties != null) {
            PokemonProperties it = pokemonProperties;
            boolean bl = false;
            PokemonBattle.sendSidedUpdate$default($battle, $actor, new BattleTransformPokemonPacket($pnx, $pokemon, it, true), new BattleTransformPokemonPacket($pnx, $pokemon, it, false), false, 8, null);
        }
        Object[] objectArray = new Object[]{pokemonName, targetPokemonName};
        class_5250 lang = LocalizationUtilsKt.battleLang("transform", objectArray);
        Intrinsics.checkNotNull((Object)lang);
        $battle.broadcastChatMessage((class_2561)lang);
        ((Map)$battle.getMinorBattleActions()).put($pokemon.getUuid(), this$0.message);
        return Unit.INSTANCE;
    }
}

